//
//  OnePasswordCoreNotifications.h
//  OnePasswordCore
//
//  Created by Roustem Karimov on 2014-06-25.
//  Copyright (c) 2014 AgileBits. All rights reserved.
//

@import Foundation;

FOUNDATION_EXPORT NSString *OPActiveProfileWillChangeNotification; // No thread guarantees
FOUNDATION_EXPORT NSString *OPActiveProfileDidChangeNotification; // No thread guarantees
FOUNDATION_EXPORT NSString *OPUIProfileSyncSettingsDidChangeNotification;

/**
 * This notification is posted by OPSyncMonitor when an unrecoverable error is detected during the sync. Notification is posted on the main thread.
 * userInfo[@"error"] contains the NSError describing the problem.
 * The object property points to the OPSyncMonitor instance that encountered the error.
 */
FOUNDATION_EXPORT NSString *OPProfileSyncMustBeDisabledNotification;

FOUNDATION_EXPORT NSString *OPProfileSyncSetupCompletedNotification;

FOUNDATION_EXPORT NSString *OPProfileChangedNotification;
FOUNDATION_EXPORT NSString *OPProfileAddedFirstOP4Profile;
FOUNDATION_EXPORT NSString *OPItemAddedOrUpdatedNotification;
FOUNDATION_EXPORT NSString *OPItemUsageChangedNotification;
FOUNDATION_EXPORT NSString *OPFavoriteChangedNotification;
FOUNDATION_EXPORT NSString *OPTagsChangedNotification;
FOUNDATION_EXPORT NSString *OPCategoryChangedNotification;
FOUNDATION_EXPORT NSString *OPFolderChangedNotification;
FOUNDATION_EXPORT NSString *OPFolderReferencesChangedNotification;
FOUNDATION_EXPORT NSString *OPWatchtowerDatabaseWillUpdateNotification;
FOUNDATION_EXPORT NSString *OPSignificantDatabaseChangeNotification;

FOUNDATION_EXPORT NSString *OPSyncMonitorWillStartNotification;
FOUNDATION_EXPORT NSString *OPSyncMonitorDidFinishNotification;
FOUNDATION_EXPORT NSString *OPSyncErrorOccurredNotification;

FOUNDATION_EXPORT NSString *OPUIRefreshEntireAppNotification;
FOUNDATION_EXPORT NSString *OPUIRefreshSidebarNotification;

FOUNDATION_EXPORT NSString *OPUIConcealPasswordsPrefChangedNotification;
FOUNDATION_EXPORT NSString *OPUIPasswordFontPrefDidChangeNotification;
FOUNDATION_EXPORT NSString *OPUIPasswordSettingsChangedNotification;
FOUNDATION_EXPORT NSString *OPUIShowRichIconsSettingsChangedNotification;

FOUNDATION_EXPORT NSString *OPUIKeychainReplicatorStarted;
FOUNDATION_EXPORT NSString *OPUIKeychainReplicatorFinished;
FOUNDATION_EXPORT NSString *OPUIKeychainReplicatorEncounteredErrorNotification;

FOUNDATION_EXPORT NSString *OPWatchtowerServicePreferenceChangedNotification;

FOUNDATION_EXPORT NSString *OPKeychainReplicaDidChangeNotification;
FOUNDATION_EXPORT NSString *OPCloudKeychainDidChangeNotification;

FOUNDATION_EXPORT NSString *OPKeychainReplicaDidReceiveDropboxAuthorizationFailureNotification;

FOUNDATION_EXPORT NSString *OPUIApplicationLockedNotification;
FOUNDATION_EXPORT NSString *OPUIApplicationUnlockedNotification;
FOUNDATION_EXPORT NSString *OPUILockViewWillAppearNotification;
FOUNDATION_EXPORT NSString *OPUILockViewDidAppearNotification;
FOUNDATION_EXPORT NSString *OPUILockViewWillDisappearNotification;
FOUNDATION_EXPORT NSString *OPUILockViewDidDisappearNotification;
FOUNDATION_EXPORT NSString *OPShowLockedViewNotification;
FOUNDATION_EXPORT NSString *OPShowLockedViewAnimatedKey;

FOUNDATION_EXPORT NSString *OPClearCachesNotification;

FOUNDATION_EXPORT NSString *OPBackupCompletedNotification;
FOUNDATION_EXPORT NSString *OPBackupRestoredNotification;
FOUNDATION_EXPORT NSString *OPBackupCopyFailedNotification;

FOUNDATION_EXPORT NSString *const OPOpenURLForLoginNotification;
FOUNDATION_EXPORT NSString *const OPOpenURLForLoginNotificationURLKey;
FOUNDATION_EXPORT NSString *const OPOpenURLForLoginNotificationItemKey;

FOUNDATION_EXPORT NSString *const OPNotificaionProfileKey;
FOUNDATION_EXPORT NSString *const OPDisplayIAPNotification;

FOUNDATION_EXPORT NSString *const OPIAPPurchasedNotification;
FOUNDATION_EXPORT NSString *const OPIAPPurchasedDistributedNotification;
FOUNDATION_EXPORT NSString *const OPIAPReceiptReadNotification;

FOUNDATION_EXPORT NSString *const OPPremiumStateChangedNotification;

FOUNDATION_EXPORT NSString *const OPDisplayHUDNotification;
FOUNDATION_EXPORT NSString *const OPDisplayHUDNotificationLargeKey;
FOUNDATION_EXPORT NSString *const OPDisplayHUDNotificationAttributedKey;

FOUNDATION_EXPORT NSString *const OPAppleWatchPreferenceDidChangeNotification;

FOUNDATION_EXPORT NSString *const OPTagSelectedNotification;

FOUNDATION_EXPORT NSString *const OPUserMessageUnreadUpdateNotification;
FOUNDATION_EXPORT NSString *const OPUserMessageUnreadNotificationCountKey;
FOUNDATION_EXPORT NSString *const OPUserMessagePublishMessageNotification;

FOUNDATION_EXPORT NSString *const OPShowVaultPickerNotification;
FOUNDATION_EXPORT NSString *const OPShowCopyVaultPickerNotification;
FOUNDATION_EXPORT NSString *const OPShowMoveVaultPickerNotification;

FOUNDATION_EXPORT NSString *const OP4VaultAddedNotification;
FOUNDATION_EXPORT NSString *const OP4VaultAddedNotificationUuidKey;
FOUNDATION_EXPORT NSString *const OP4VaultAddedNotificationNameKey;

FOUNDATION_EXPORT NSString *const OP4VaultDeletedNotification;
FOUNDATION_EXPORT NSString *const OP4VaultDeletedNotificationUuidKey;
FOUNDATION_EXPORT NSString *const OP4VaultDeletedNotificationNameKey;

FOUNDATION_EXPORT NSString *const OPSelectCategoriesTabNotification;

/* B5 */

typedef NS_ENUM(NSUInteger, B5UserAccountStateChangeReason) {
	B5UserAccountStateChangeReasonUnknown = 0,
	B5UserAccountStateChangeReasonUserRequested = 1,
	B5UserAccountStateChangeReasonAccountSuspended = 2,
	B5UserAccountStateChangeReasonAccountDeleted = 3,
	B5UserAccountStateChangeReasonDeviceDeauthorized = 4,
};

// Vault Added
FOUNDATION_EXPORT NSString *const B5VaultAddedNotification;
FOUNDATION_EXPORT NSString *const B5VaultAddedNotificationUuidKey; // uuid of B5Profile
FOUNDATION_EXPORT NSString *const B5VaultAddedNotificationNameKey; // display name of B5Profile
FOUNDATION_EXPORT NSString *const B5VaultAddedNotificationAccountId; // OPID of B5UserAccount
FOUNDATION_EXPORT NSString *const B5VaultAddedNotificationAccountName; // accountName of B5UserAccount

// Vault Deleted
FOUNDATION_EXPORT NSString *const B5VaultsWillDeleteNotification;
FOUNDATION_EXPORT NSString *const B5VaultsWillDeleteNotificationAccountIdKey;
FOUNDATION_EXPORT NSString *const B5VaultsWillDeleteNotificationUuidsKey;

FOUNDATION_EXPORT NSString *const B5VaultDeletedNotification;
FOUNDATION_EXPORT NSString *const B5VaultDeletedNotificationUuidKey;
FOUNDATION_EXPORT NSString *const B5VaultDeletedNotificationNameKey;
FOUNDATION_EXPORT NSString *const B5VaultDeletedNotificationAccountId;
FOUNDATION_EXPORT NSString *const B5VaultDeletedNotificationAccountName;

// Account Added - Broadcast after an account has been added.
FOUNDATION_EXPORT NSString *const B5UserAccountAddedNotification;
FOUNDATION_EXPORT NSString *const B5UserAccountAddedNotificationAccountIdKey;
FOUNDATION_EXPORT NSString *const B5UserAccountAddedNotificationAccountNameKey;

// Account Deleted - Broadcast before any account has been deleted, regardless of reason (for example the user may have deleted it using the UI, or the system may have deleted it due to the server asking us to)
FOUNDATION_EXPORT NSString *const B5UserAccountWillDeleteNotification;
FOUNDATION_EXPORT NSString *const B5UserAccountWillDeleteNotificationAccountIdKey;

// Account Deleted - Broadcast after any account has been deleted, regardless of reason (for example the user may have deleted it using the UI, or the system may have deleted it due to the server asking us to)
FOUNDATION_EXPORT NSString *const B5UserAccountDeletedNotification;
FOUNDATION_EXPORT NSString *const B5UserAccountDeletedNotificationAccountIdKey;
FOUNDATION_EXPORT NSString *const B5UserAccountDeletedNotificationAccountNameKey;

// Account State Changed - Broadcast before the change to the property about to happen and any necessary dependent work (if any)
FOUNDATION_EXPORT NSString *const B5UserAccountStateWillChangeNotification;
FOUNDATION_EXPORT NSString *const B5UserAccountStateWillChangeNotificationAccountIdKey;
FOUNDATION_EXPORT NSString *const B5UserAccountStateWillChangeNotificationAccountStateKey;

// Account State Changed - Broadcast after the change to the property has happened and any necessary dependent work (if any)
FOUNDATION_EXPORT NSString *const B5UserAccountStateChangedNotification;
FOUNDATION_EXPORT NSString *const B5UserAccountStateChangedNotificationAccountIdKey;
FOUNDATION_EXPORT NSString *const B5UserAccountStateChangedNotificationAccountNameKey;
FOUNDATION_EXPORT NSString *const B5UserAccountStateChangedNotificationAccountStateKey;
FOUNDATION_EXPORT NSString *const B5UserAccountStateChangedNotificationReasonKey; // B5UserAccountStateChangeReason

// Awaiting Recovery Approval
FOUNDATION_EXPORT NSString *const B5UserRecoveryAwaitingApprovalNotification;
FOUNDATION_EXPORT NSString *const B5UserRecoveryAwaitingApprovalNotificationAccountIdKey;
FOUNDATION_EXPORT NSString *const B5UserRecoveryAwaitingApprovalNotificationAccountNameKey;

// Account Deletion Request - Broadcast when the server returns an error indicating that the account is deleted server-side and the client should purge it immediately.
FOUNDATION_EXPORT NSString *const B5UserAccountDeletionRequestedNotification;
FOUNDATION_EXPORT NSString *const B5UserAccountDeletionRequestedNotificationAccountIdKey;
FOUNDATION_EXPORT NSString *const B5UserAccountDeletionRequestedNotificationAccountNameKey;
FOUNDATION_EXPORT NSString *const B5UserAccountDeletionRequestedNotificationReasonKey; // B5UserAccountStateChangeReason

// Account Suspension Request - Broadcast when the server returns an error indicating that the account is suspended server-side and the client should block access to the data.
FOUNDATION_EXPORT NSString *const B5UserAccountSuspensionRequestedNotification;
FOUNDATION_EXPORT NSString *const B5UserAccountSuspensionRequestedNotificationAccountIdKey;
FOUNDATION_EXPORT NSString *const B5UserAccountSuspensionRequestedNotificationAccountNameKey;

// Deprecated API Notification - Broadcast when the client gets an error from the server that a API is deprecated, meaning they should update their client
FOUNDATION_EXPORT NSString *const B5UserAccountDeprecatedAPINotification;
FOUNDATION_EXPORT NSString *const B5UserAccountDeprecatedAPINotificationErrorKey;

// Master Account Change - Broadcast when we change the B5 Master Account and migrate login dictionaries to the new Master Account
FOUNDATION_EXPORT NSString *const B5UserAccountMasterChangedNotification;
FOUNDATION_EXPORT NSString *const B5UserAccountMasterChangedNotificationFromAccountIdKey;
FOUNDATION_EXPORT NSString *const B5UserAccountMasterChangedNotificationFromAccountNameKey;
FOUNDATION_EXPORT NSString *const B5UserAccountMasterChangedNotificationToAccountIdKey;
FOUNDATION_EXPORT NSString *const B5UserAccountMasterChangedNotificationToAccountNameKey;

// Announce Sync
FOUNDATION_EXPORT NSString *const B5UserAccountRequiresSyncNotification; // object contains account uuid

// Reauth - e.g. when password is changed on another client
FOUNDATION_EXPORT NSString *const B5UserAccountRequiresReauthNotification;
FOUNDATION_EXPORT NSString *const B5UserAccountRequiresReauthNotificationAccountIdKey; // OPID of B5UserAccount
FOUNDATION_EXPORT NSString *const B5UserAccountRequiresReauthNotificationNewEmailKey; // If present, this should be the email address used for authentication
